// Created with UO Weapon Generator
// Created On: 9/10/2007 6:30:36 AM
// By: Hammerhand

using System;
using Server;

namespace Server.Items
{
	public class ASoullessBlade : RadiantScimitar
	{
		public static Type[] ExtraLoot = new Type[]
		{
         typeof( MagicalWire ), typeof( SlzaAuberonu ), typeof( MesicniKamen ), typeof( SkillBall ),
			typeof( WonderousLevelUpScroll ), typeof( ExaltedLevelUpScroll ), typeof( MythicalLevelUpScroll ),
			typeof( LegendaryLevelUpScroll ), typeof( GlassSword ), 
			typeof( PowerScroll ), typeof( RandomLevelItemBag ), typeof( RandomLevelClothingBag ), typeof( RandomPlateOfHonorBag ),
			typeof( PSToken ), typeof( PetPowerScroll ), typeof( SpendingPointsScroll ),
// 			typeof( RunicBl ), typeof( RunicDa ), typeof( RunicFw ), typeof( CarpRunicFw ), typeof( TinkerRunicBl ),
			typeof( MagicScroll )
		};
      
      public override int ArtifactRarity{ get{ return 80; } }
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		public override int AosMinDamage{ get{ return 14; } }
		public override int AosMaxDamage{ get{ return 18; } }

		[Constructable]
		public ASoullessBlade()
		{
			Name = "A Soulless Blade";
			Hue = 1101;

			Attributes.NightSight = 1;
			Attributes.BonusStr = 7;
			Attributes.BonusStam = 8;
			Attributes.RegenStam = 10;

			WeaponAttributes.UseBestSkill = 1;
			WeaponAttributes.HitLeechStam = 30;
			WeaponAttributes.HitLeechHits = 30;
			WeaponAttributes.HitLeechMana = 30;

			Attributes.WeaponDamage = 35;
			Attributes.WeaponSpeed = 26;
			Attributes.ReflectPhysical = 25;

			WeaponAttributes.ResistColdBonus = 20;
			WeaponAttributes.ResistFireBonus = 20;
			WeaponAttributes.ResistPoisonBonus = 20;
			WeaponAttributes.SelfRepair = 5;
			WeaponAttributes.HitHarm = 25;
			WeaponAttributes.HitLightning = 30;
			WeaponAttributes.HitFireball = 30;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#33FF66>Chance to find extra item<basefont color=White>" );
		}
		
		public ASoullessBlade(Serial serial) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	} // End Class
} // End Namespace
